@extends('layouts.app')

@section('content')
<script src="{{asset('public/assets/metamask/block.js')}}"></script>

<!--**********************************
            Content body start
        ***********************************-->
		<div class="content-body">
			<div class="container-fluid">
				<div class="row">
					<div class="swiper-slide">
						<div class="card-bx stacked card">
							<img src="{{asset('public/assets')}}/images/card/card1.jpg" alt="">
							<div class="card-info">
								<p class="mb-1 text-white fs-14">Main Balance</p>
								<div class="d-flex justify-content-between">
									<h2 class="num-text text-white mb-5 font-w600">${{$trade+$sponser+$level}}</h2>
									<svg width="36" height="36" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M19.2744 18.8013H16.0334V23.616H19.2744C19.9286 23.616 20.5354 23.3506 20.9613 22.9053C21.4066 22.4784 21.672 21.8726 21.672 21.1989C21.673 19.8813 20.592 18.8013 19.2744 18.8013Z" fill="white"/>
										<path d="M18 0C8.07429 0 0 8.07429 0 18C0 27.9257 8.07429 36 18 36C27.9257 36 36 27.9247 36 18C36 8.07531 27.9247 0 18 0ZM21.6627 26.3355H19.5398V29.6722H17.3129V26.3355H16.0899V29.6722H13.8528V26.3355H9.91954V24.2414H12.0898V11.6928H9.91954V9.59863H13.8528V6.3288H16.0899V9.59863H17.3129V6.3288H19.5398V9.59863H21.4735C22.5535 9.59863 23.5491 10.044 24.2599 10.7547C24.9706 11.4655 25.416 12.4611 25.416 13.5411C25.416 15.6549 23.7477 17.3798 21.6627 17.4744C24.1077 17.4744 26.0794 19.4647 26.0794 21.9096C26.0794 24.3453 24.1087 26.3355 21.6627 26.3355Z" fill="white"/>
										<path d="M20.7062 15.8441C21.095 15.4553 21.3316 14.9338 21.3316 14.3465C21.3316 13.1812 20.3842 12.2328 19.2178 12.2328H16.0334V16.4695H19.2178C19.7959 16.4695 20.3266 16.2226 20.7062 15.8441Z" fill="white"/>
									</svg>
								</div>
								<div class="d-flex">
									<div class="me-4 text-white">
										<p class="fs-12 mb-1 op6">Trading</p>
										<span>${{$trade}}</span>
									</div>
									<div class="me-4 text-white">
										<p class="fs-12 mb-1 op6">Sponser</p>
										<span>${{$sponser}}</span>
									</div>
									<div class="me-4 text-white">
										<p class="fs-12 mb-1 op6">Level Income</p>
										<span>${{$level}}</span>
									</div>
									<div class="me-4 text-white">
										<p class="fs-12 mb-1 op6">Level</p>
										<span>{{Auth::user()->level}}</span>
									</div>
									<div class="me-4 text-white">
										<p class="fs-12 mb-1 op6">Stacking</p>
										<span>${{$stack}}</span>
									</div>
								</div>
							</div>
						</div>
					</div>
					<div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Topup Your Wallet</h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                    <form action="#">
                                    	
										<div class="mb-3">
											<label class="form-label">Amount in Ether (100-2000)</label>
                                            <input type="text" id="ether" class="form-control input-default" placeholder="Enter your Amount in Ether" name="amount" required>
                                        </div>
                                        <div class="mb-3">
                                            <label class="form-label">Select Plan</label>
                                            <select class="default-select form-control wide" required="" id="plan_id">
                                            	<option value="">--Select Plan--</option>
                                                @foreach($plans as $plan)
                                                <option value="{{$plan->id}}">{{$plan->months}} Months - {{$plan->bonus}}% Bonus</option>
                                                @endforeach
                                            </select>
                                        </div>
										<div class="mb-3">
                                            <label class="form-label">Select Your Paymet Method</label>
                                            <select class="default-select  form-control wide">
                                                <option>Metamask</option>
                                            </select>
                                        </div>
										<button type="button" id="topup" class="btn btn-rounded btn-info" style="float: right; display: none;"><span
											class="btn-icon-start text-info"><i class="fa fa-plus color-info"></i>
										</span>Topup</button>
										<button type="button" id="enable" class="btn btn-rounded btn-success" style="display: none;">Connect Metamask</button>
										<button type="button" onclick="window.location='https://metamask.io/download'" id="install" class="btn btn-rounded btn-success" style="display: none;">Install Metamask</button>
                                    </form>
                                    <!-- <p id="account">Account: </p>
                                    <p id="balance">Balance: </p> -->
                                </div>
                            </div>
                        </div>
						
					</div>

					<!-- <div id="status"></div> -->

					<div class="col-xl-6 col-lg-6">
                        <div class="card">
                            <div class="card-header">
                                <h4 class="card-title">Withdraw Amount</h4>
                            </div>
                            <div class="card-body">
                                <div class="basic-form">
                                    <form form="{{url('wallet')}}" method="post">
                                    	@csrf

										<div class="mb-3">
											<label class="form-label">Amount in Ether (Minimum 20)</label>
                                            <input type="number" min="20" class="form-control input-default" name="amount" placeholder="Enter your Amount" required="">
                                        </div>
										<div class="mb-3">
                                            <label class="form-label">Select Your Paymet Method</label>
                                            <select class="default-select  form-control wide" >
                                                <option>Bank Transfer</option>
                                            </select>
                                        </div>
                                        <input type="hidden" name="total" value="{{$trade+$sponser+$level}}">
										<button class="btn btn-rounded btn-warning" style="float: right;"><span
											class="btn-icon-start text-warning"><i class="fa fa-download color-warning"></i>
										</span>Withdraw</button>
                                    </form>
                                </div>
                            </div>
                        </div>
						
					</div>
					<div class="col-xl-12  mt-4">
						<div class="row">
							<div class="col-xl-12">
								<div class="card">
									<div class="card-header pb-2 d-block d-sm-flex flex-wrap border-0">
										<div class="mb-3">
											<h4 class="fs-20 text-black">Wallet Activity</h4>
											<p class="mb-0 fs-13">Your Wallet Activity</p>
										</div>

									</div>
									<div class="card-body tab-content p-0">
										<div class="tab-pane active show fade" id="monthly">
											<div class="table-responsive">
												<table
													class="table shadow-hover card-table border-no tbl-btn short-one">
													<tbody>
														@foreach($data as $row)
														<tr>

															@if($row->type == 0)
															<td>
																<span>
																	<svg width="50" height="50" viewBox="0 0 63 63"
																		fill="none" xmlns="http://www.w3.org/2000/svg">
																		<rect width="63" height="63" rx="14"
																			fill="#625794" />
																		<path
																			d="M37.2692 38.9908L37.2692 38.9908L32.3961 43.8874C32.3934 43.8902 32.3909 43.8927 32.3885 43.895M37.2692 38.9908L32.0389 43.5375L32.3918 43.8917C32.3825 43.9009 32.3749 43.9078 32.3716 43.9107L32.3705 43.9117C32.373 43.9095 32.3796 43.9036 32.3877 43.8957C32.388 43.8955 32.3883 43.8952 32.3885 43.895M37.2692 38.9908C37.8291 38.4281 37.827 37.5179 37.2643 36.9578C36.7016 36.3978 35.7914 36.3999 35.2314 36.9626L35.2313 36.9627L32.8127 39.393M37.2692 38.9908L32.8127 39.393M32.3885 43.895C31.8292 44.4509 30.9226 44.4526 30.3615 43.8946C30.3603 43.8934 30.3591 43.8922 30.3578 43.8909L30.3563 43.8894L30.3442 43.8773L25.4813 38.9908L25.8357 38.6381L25.4813 38.9908C24.9215 38.4282 24.9234 37.518 25.4862 36.9578C26.049 36.3978 26.9591 36.4 27.5191 36.9627L27.5192 36.9627L29.9377 39.393L29.9377 20.75C29.9377 19.9561 30.5813 19.3125 31.3752 19.3125C32.1692 19.3125 32.8127 19.9561 32.8127 20.75L32.8127 39.393M32.3885 43.895C32.39 43.8935 32.3914 43.8921 32.3928 43.8907L32.8127 39.393M30.3577 43.8908C30.3573 43.8903 30.3568 43.8899 30.3564 43.8894L30.3577 43.8908Z"
																			fill="white" stroke="white" />
																	</svg>
																</span>
															</td>
															<td>
																<span class="font-w600 text-black">Withdraw</span>
															</td>
															@else
															<td>
																<span>
																	<svg width="50" height="50" viewBox="0 0 63 63"
																		fill="none" xmlns="http://www.w3.org/2000/svg">
																		<rect width="63" height="63" rx="14"
																			fill="#625794" />
																		<path
																			d="M25.4813 24.6343L25.4813 24.6343L30.3544 19.7376C30.3571 19.7348 30.3596 19.7323 30.3619 19.7301M25.4813 24.6343L30.7116 20.0875L30.3587 19.7333C30.368 19.7241 30.3756 19.7172 30.3789 19.7143L30.38 19.7133C30.3775 19.7155 30.3709 19.7214 30.3627 19.7293C30.3625 19.7295 30.3622 19.7298 30.3619 19.7301M25.4813 24.6343C24.9214 25.197 24.9234 26.1071 25.4862 26.6672C26.0489 27.2273 26.9591 27.2251 27.5191 26.6624L27.5192 26.6624L29.9377 24.232M25.4813 24.6343L29.9377 24.232M30.3619 19.7301C30.9212 19.1741 31.8279 19.1724 32.389 19.7304C32.3902 19.7316 32.3914 19.7329 32.3927 19.7341L32.3941 19.7356L32.4062 19.7477L37.2691 24.6342L36.9147 24.9869L37.2692 24.6342C37.829 25.1968 37.8271 26.107 37.2642 26.6672C36.7015 27.2272 35.7914 27.225 35.2314 26.6623L35.2313 26.6623L32.8127 24.232L32.8127 42.875C32.8127 43.6689 32.1692 44.3125 31.3752 44.3125C30.5813 44.3125 29.9377 43.6689 29.9377 42.875L29.9377 24.232M30.3619 19.7301C30.3605 19.7315 30.3591 19.7329 30.3577 19.7343L29.9377 24.232M32.3927 19.7342C32.3932 19.7347 32.3937 19.7351 32.3941 19.7356L32.3927 19.7342Z"
																			fill="white" stroke="white" />
																	</svg>
																</span>
															</td>
															<td>
																<span class="font-w600 text-black">Topup</span>
															</td>
															@endif


															<td>
																<span class="text-black">{{date('d/m/Y',strtotime($row->created_at))}}</span>
															</td>
															<td>
																<span class="text-black">{{date('h:i a',strtotime($row->created_at))}}</span>
															</td>
															<td>
																<span class="font-w600 text-black">
														@if($row->type == 0) -
														@else + @endif ${{$row->amount}}</span>
															</td>
															<td><a class="btn-link text-success float-right"
																	href="javascript:void(0);">{{$row->status}}</a></td>
														</tr>
														@endforeach
														<!-- <tr>
															<td>
																<span>
																	<svg width="50" height="50" viewBox="0 0 63 63"
																		fill="none" xmlns="http://www.w3.org/2000/svg">
																		<rect width="63" height="63" rx="14"
																			fill="#625794" />
																		<path
																			d="M37.2692 38.9908L37.2692 38.9908L32.3961 43.8874C32.3934 43.8902 32.3909 43.8927 32.3885 43.895M37.2692 38.9908L32.0389 43.5375L32.3918 43.8917C32.3825 43.9009 32.3749 43.9078 32.3716 43.9107L32.3705 43.9117C32.373 43.9095 32.3796 43.9036 32.3877 43.8957C32.388 43.8955 32.3883 43.8952 32.3885 43.895M37.2692 38.9908C37.8291 38.4281 37.827 37.5179 37.2643 36.9578C36.7016 36.3978 35.7914 36.3999 35.2314 36.9626L35.2313 36.9627L32.8127 39.393M37.2692 38.9908L32.8127 39.393M32.3885 43.895C31.8292 44.4509 30.9226 44.4526 30.3615 43.8946C30.3603 43.8934 30.3591 43.8922 30.3578 43.8909L30.3563 43.8894L30.3442 43.8773L25.4813 38.9908L25.8357 38.6381L25.4813 38.9908C24.9215 38.4282 24.9234 37.518 25.4862 36.9578C26.049 36.3978 26.9591 36.4 27.5191 36.9627L27.5192 36.9627L29.9377 39.393L29.9377 20.75C29.9377 19.9561 30.5813 19.3125 31.3752 19.3125C32.1692 19.3125 32.8127 19.9561 32.8127 20.75L32.8127 39.393M32.3885 43.895C32.39 43.8935 32.3914 43.8921 32.3928 43.8907L32.8127 39.393M30.3577 43.8908C30.3573 43.8903 30.3568 43.8899 30.3564 43.8894L30.3577 43.8908Z"
																			fill="white" stroke="white" />
																	</svg>
																</span>
															</td>
															<td>
																<span class="font-w600 text-black">Withdraw</span>
															</td>
															<td>
																<span class="text-black">20/3/2021</span>
															</td>
															<td>
																<span class="text-black">06:24:45 AM</span>
															</td>
															<td>
																<span class="font-w600 text-black">+$5,553</span>
															</td>
															<td>
																<a class="btn-link text-dark float-right"
																	href="javascript:void(0);">Pending</a>
															</td>
														</tr> -->
									
													</tbody>
												</table>
											</div>
										</div>
									</div>
									<div class="card-footer border-0 p-0 caret">
										<a href="#" class="btn-link mt-1"><i class="fa fa-caret-down"
												aria-hidden="true"></i></a>
									</div>
								</div>
							</div>
						</div>
					</div>




				</div>



			</div>
		</div>
		<!--**********************************
            Content body end
        ***********************************-->

        <script type="text/javascript">
        	if (typeof window.ethereum !== 'undefined') {
    var x = document.getElementById("enable");
    var y = document.getElementById("topup");
    x.style.display = "block";
}
else{
	var x = document.getElementById("install");
    x.style.display = "block";
}


// let accounts = [];

// //Sending Ethereum to an address
// function send()
// {
//    getAccount()

//   ethereum
//     .request({
//       method: 'eth_sendTransaction',
//       params: [
//         {
//           nonce: 0,
//           from: accounts[0],
//           to: '0x13836566516e8903ba45Eec35EF240E630867547',
//           value: '0x29a2241af62c0000',
//           gasPrice: '0x09184e72a000',
//           gas: '0x2710',
//         },
//       ],
//     })
//     .then((txHash) => console.log(txHash))
//     .catch((error) => alert('Kindly Connect Metamask'));
// }

// async function getAccount() {
//   accounts = await ethereum.request({ method: 'eth_requestAccounts' });
// }

let account;
document.getElementById('enable').addEventListener('click', event => {
        let button = event.target;
        ethereum.request({method: 'eth_requestAccounts'}).then(accounts => {
          account = accounts[0];
          console.log(account);
          button.textContent = 'Connected';
          y.style.display = "block";

          // ethereum.request({method: 'eth_getBalance' , params: [account, 'latest']}).then(result => {
          //   console.log(result);
          //   let wei = parseInt(result,16);
          //   let balance = wei / (10**18);
          //   console.log(balance + " ETH");
          // });
        });
      });


        document.getElementById('topup').addEventListener('click', event =>{
        let ether = document.getElementById("ether").value;
        let product_id = $("#plan_id").val();
          if(ether < 100 || ether > 2000)
          {
          	alert('Please Enter Amount (100-2000)');
          	return;
          }

          if(product_id == '')
          {
          	alert('Please Select Plan');
          	return;
          }

          let wei = ether * (10**18);
          let hex = wei.toString(16);
          let transactionParam = {
            to: '0x45B6b39e1Cf8A6b4Ff2720f6BA0089d4574126E5',
            from: account,
            value: hex
          };
          
          ethereum.request({method: 'eth_sendTransaction', params:[transactionParam]}).then(txhash => {



              console.log(txhash);	
              var _token = "{{@csrf_token()}}";
              $.ajax({
               url:"{{ url('add-to-wallet') }}",
               method:"POST",
               data:{_token:_token, txhash:txhash, amount:ether, product_id:product_id},
               success:function(data){
                 if(data == 1)
               	 {
               	 	alert('Transaction Success');
                    location.reload();
               	 }
               	 else
               	 {
               	 	alert('JQuerry Failed');
               	 }
               }
              });



          })
          .catch((error) => {



              var _token = "{{@csrf_token()}}";
              $.ajax({
               url:"{{ url('add-to-wallet') }}",
               method:"POST",
               data:{_token:_token, txhash:'TNX', amount:ether, product_id:product_id},
               success:function(data){
               	 if(data == 1)
               	 {
               	 	alert('Transaction Success');
                    location.reload();
               	 }
               	 else
               	 {
               	 	alert('JQuerry Failed');
               	 }
               }
              });
          	alert('Transaction Failed');





          });
        });
      
      // function checkTransactionconfirmation(txhash) {

      //   let checkTransactionLoop = () => {
      //     return ethereum.request({method:'eth_getTransactionReceipt',params:[txhash]}).then(r => {
      //       if(r !=null) return 'confirmed';
      //       else return checkTransactionLoop();
      //     });
      //   };

      //   return checkTransactionLoop();
      // }

        </script>

@endsection