@extends('admin.layouts.app')
@section('content')

    <!-- Main content -->
    <section class="content">
      <div class="container-fluid">
       <div class="row">
        <div class="col-md-12">
          <div class="card card-primary">
              <div class="card-header">
                <h3 class="card-title">Edit Blog</h3>
              </div>
              <!-- /.card-header -->
              <!-- form start -->
              @if(Session::has('flash_error'))
                  <div class="alert alert-danger m-2">
                      <button type="button" class="close" data-dismiss="alert">×</button>
                  {{ Session::get('flash_error') }}
                  </div>
              @endif
              <form enctype="multipart/form-data" role="form" id="myform" method="post" action="{{ route('blogs.update',$data->id) }}">
                @csrf

                @method('PATCH')
                
                <div class="container">
                 <div class="row">
                    <div class="col-sm-12">


                          <div class="form-group mt-2">
                            <label for="image">Image</label><br>
                            <img src="{{ URL::to('/public') }}/uploads/images/{{ $data->image }}" alt="" class="img-responsive" width="200px" />
                         
                                <input type="file" name="image" class="form-control" id="image">
                                  @if ($errors->has('image'))
                                      <span class="required">
                                          <strong>{{ $errors->first('image') }}</strong>
                                      </span>
                                  @endif
                          </div>

                        
                          
                          <div class="form-group">
                            <label for="name" class="form-label">Title</label>
                               <input type="text" class="form-control" id="exampleInputPassword1" name="title" value="{{$data->title}}" required>
                          </div>

                          <div class="form-group">
                            <label for="name" class="form-label">User</label>
                               <input type="text" class="form-control" id="exampleInputPassword1" name="user" value="{{$data->user}}" required>
                          </div>



                          <div class="form-group">
                            <label for="overview">Blog content</label>
                    <textarea rows="5" class="form-control" id="desc" name="desc" required><?php echo $data->desc; ?></textarea>
                              
                               
                            </div>

                          <div class="form-group">
                          <label for="chkYes">
                              <input type="radio" class="status" value="Active" name="status" @if($data->status == 'Active') checked @endif/>
                              @if ($errors->has('status'))
                                <span class="required">
                                    <strong>{{ $errors->first('status') }}</strong>
                                </span>
                            @endif  
                              Active
                          </label>
                          <label for="chkNo">
                              <input type="radio" class="status" value="InActive" name="status" @if($data->status == 'InActive') checked @endif />
                              @if ($errors->has('status'))
                                <span class="required">
                                    <strong>{{ $errors->first('status') }}</strong>
                                </span>
                            @endif  
                              Inactive
                          </label>
                        </div>
                        
                           <div class="form-group">
                            <button id="submit" type="submit" class="btn btn-primary">Update Blog</button>
                          </div>
                    </div>
                 </div>
                </div>
              </form>
          </div>
        </div>
       </div>
      </div><!-- /.container-fluid -->
    </section>
    <!-- /.content -->
@endsection
