@extends('layouts.app')

@section('content')
  
  <!-- wishlist-area start -->
  <div class="wishlist-area">
    <div class="container">
      <div class="row">
        <div class="col-md-12 col-sm-12">
          <div class="wishlist-content">
            <div class="wishlist-title">
              <h2>My wishlist </h2>
              @if(Session::has('flash_success'))
                      <div class="alert alert-success">
                      {{ Session::get('flash_success') }}
                      </div>
                  @endif 
            </div>
            @if(count($wishlists))
            <div class="wishlist-table table-responsive">
              <table>
                <thead>
                  <tr>
                    <th class="product-remove"><span class="nobr">Action</span></th>
                    <th class="product-thumbnail">Image</th>
                    <th class="product-name"><span class="nobr">Product Name</span></th>
                    <th class="product-price"><span class="nobr"> Unit Price </span></th>
                    <th class="product-stock-stauts"><span class="nobr"> Stock Status </span></th>
                    <th class="product-add-to-cart"><span class="nobr">Add To Cart </span></th>
                  </tr>
                </thead>
                <tbody>
                  @foreach($wishlists as $wishlist)
                  <tr>
                    <td class="product-remove"><a href="{{url('delWishlist/')}}/{{$wishlist->id}}/session_id/{{$wishlist->session_id}}">×</a></td>
                    <td class="product-thumbnail"><a href="#">
                    <img src="{{ url('public/uploads/images') }}/{{@$wishlist->product->productImage->image}}" alt="" />
                    </a>
                    </td>
                    <td class="product-name"><a href="{{url('/p')}}/{{$wishlist->product->slug}}">{{$wishlist->product->name}}</a></td>
                    <td class="product-price"><span class="amount">Rs {{$wishlist->product->selling_price}}</span></td>
                    <td class="product-stock-status"><span class="wishlist-in-stock">In Stock</span></td>
                    <td class="product-add-to-cart"><a href="{{url('addtoCart-wishlist')}}/{{$wishlist->id}}/session_id/{{$wishlist->session_id}}"> Add to Cart</a></td>
                  </tr>
                  @endforeach
                </tbody>
                <!-- <tfoot>
                  <tr>
                    <td colspan="6">
                      <div class="wishlist-share">
                        <h4 class="wishlist-share-title">Share on:</h4>
                        <ul>
                          <li><a class="facebook" href="#"></a></li>
                          <li><a class="twitter" href="#"></a></li>
                          <li><a class="pinterest" href="#"></a></li>
                          <li><a class="googleplus" href="#"></a></li>
                          <li><a class="email" href="#"></a></li>
                        </ul>
                      </div>
                    </td>
                  </tr>
                </tfoot> -->
              </table>
            </div>  
            @else
            <h1 class="text-center" style="padding-top: 100px; padding-bottom: 200px;">No Items in wishlist</h1>
            @endif
          </div>
        </div>
      </div>
    </div>
  </div>
  <!-- wishlist-area end -->
@endsection