@extends('layouts.app')

@section('content')
<!-- my-account-area start -->
  <div class="my-account-area">
    <div class="container" style="padding-top: 100px;">
      <div class="row">
        <div class="col-md-3"></div>
        <div class="col-md-6">
          <form method="POST" action="{{ route('register') }}">
            @csrf
            <div class="form-fields">
              <h2>Signup</h2>
              <p>
                <label>Full Name <span class="required">*</span></label>
                <input type="text" id="name" name="name" class="@error('name') is-invalid @enderror" value="{{ old('name') }}"  required>
                   @error('name')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
              </p>
              <p>
                <label>Phone </label>
                <input type="number" min="0" id="phone" name="phone" class="@error('phone') is-invalid @enderror" value="{{ old('phone') }}" required>
                  @error('phone')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
              </p>
              
              <p>
                <label>Email </label>
                <input type="text" id="email" name="email" class="@error('email') is-invalid @enderror" value="{{ old('email') }}" required>
                  @error('email')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
              </p>
              
              <p>
                <label>Password <span class="required">*</span></label>
                <input type="password" name="password" id="password" class="@error('password') is-invalid @enderror" value="{{ old('password') }}" required>
                  @error('password')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
              </p>
              <p>
                <label>Confirm Password <span class="required">*</span></label>
                <input type="password" name="password_confirmation" id="password_confirmation" required>
              </p>
              <p>
                <label>State <span class="required">*</span></label>
                <select class="form-control" name="state_id">
                  @foreach($states as $state)
                  <option value="{{$state->id}}">{{ $state->name }}</option>
                  @endforeach
                </select>
              </p>
              <p>
                <label>City <span class="required">*</span></label>
                <input type="text" name="city" id="city" class="@error('city') is-invalid @enderror" value="{{ old('city') }}" required>
                  @error('city')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
              </p>
              <p>
                <label>Pincode <span class="required">*</span></label>
                <input type="number" min="0" name="pincode" id="pincode" class="@error('pincode') is-invalid @enderror" value="{{ old('pincode') }}" required>
                  @error('pincode')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
              </p>
              <p>
                <label>Address <span class="required">*</span></label>
                <textarea class="form-control @error('address') is-invalid @enderror" name="address">{{ old('address') }}</textarea>
                  @error('address')
                        <span class="invalid-feedback" role="alert">
                            <strong>{{ $message }}</strong>
                        </span>
                    @enderror
              </p>
              
            </div>
            <div class="form-action">
              <button type="submit" class="btn btn-dark">Submit</button>              
            </div>
          </form>
        </div>
        <div class="col-md-3"></div>
      </div>
    </div>
  </div>
  <!-- my-account-area end -->
@endsection