<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Contact;
use App\Models\Product;
use App\User;

class HomeController extends Controller
{
    public function index(Request $request)
    {
        $users = User::where('role_id',2)->count();
        $plans = Product::where('status','Active')->count();
    	return view('admin.home',compact('users','plans'));
    }

    public function contacts(Request $request)
    {
        $data = Contact::orderBy('id','desc')->paginate(10);
        return view('admin.contacts.index',compact('data'));
    }

    public function contacts_reply($id)
    {
        $data = Contact::find($id);
        return view('admin.contacts.reply',compact('data'));
    }

    public function contacts_reply_send(Request $request)
    {
        $site_details = SiteDetail::find(1);

  $message=$request->message;

  $to = $request->email;
  $subject = "Contact Us";
  
$message_ = '
<html> 
<head>
<title>Contact us</title>
</head>
<body>
<p>'.$request->reply.'</p>
<h4>Thank you<br>'.$site_details->name.' Team</h4>
</body> 
</html>
';

// Always set content-type when sending HTML email
$headers = "MIME-Version: 1.0" . "\r\n";
$headers .= "Content-type:text/html;charset=UTF-8" . "\r\n";

// More headers
$headers .= 'From: '.$site_details->name.' <'.$site_details->email.'>' . "\r\n";
   
    @mail($to,$subject,$message_,$headers);
    return redirect('admin/contacts')->with('flash_success', 'Reply sent successfully');
    }

    public function deleteContacts(Request $request)
    {
        $data = Contact::find($request->id);
        $data->delete();
        return back()->with('flash_success', 'Contact Message deleted successfully');
    }

    public function site_setting()
    {
        $site_details = SiteDetail::find(1);
        return view('admin.site-setting',compact('site_details'));
    }

    public function site_setting_update(Request $request)
    {
        $site_details = SiteDetail::find(1);
        $site_details->name = $request->name;
        $site_details->email = $request->email;
        $site_details->phone = $request->phone;
        $site_details->address = $request->address;
        $site_details->description = $request->description;
        $site_details->keyword = $request->keyword;
        $site_details->about = $request->about;
        if($request->hasfile('about_banner'))
        {
            @unlink('public/uploads/images/'.$site_details->about_banner);
            $file = $request->file('about_banner');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $site_details->about_banner = $filename;
        }
        $site_details->why = $request->why;
        if($request->hasfile('why_banner'))
        {
            @unlink('public/uploads/images/'.$site_details->why_banner);
            $file = $request->file('why_banner');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $site_details->why_banner = $filename;
        }
        $site_details->map = $request->map;
        $site_details->footer = $request->footer;
        $site_details->facebook = $request->facebook;
        $site_details->instagram = $request->instagram;
        $site_details->twitter = $request->twitter;
        $site_details->youtube = $request->youtube;
        $site_details->linkedin = $request->linkedin;
        if($request->hasfile('image'))
        {
            @unlink('public/uploads/images/'.$site_details->image);
            $file = $request->file('image');
            $filename = time() . '.' . $file->getClientOriginalExtension($file);
            $filePath = 'uploads/images/' . $filename;
            $file->move(public_path('uploads/images'),$filePath); 
            $site_details->image = $filename;  
        }
        $site_details->save();
        return back()->with('flash_success', 'Site settings updated successfully');
    }
}